package org.msh.tb.bd.tbforms.dhis2.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by Mauricio on 03/02/2017.
 * DTO that mount and holds the request payload used when sending TB Forms values to DHIS2
 */
public class DataValuePayload {

    /**
     * Mandatory
     * The data set id in DHIS2
     */
    private String dataSet;

    /**
     * Not Mandatory
     * The date the information was calculated.
     */
    private Date completeData;

    /**
     * Mandatory
     * The period that the data values refer to.
     * For TB 10 and 11 this must be in quarter format yyyyMM
     */
    private String period;

    /**
     * Mandatory
     * The tbunit id in DHIS2
     */
    private String orgUnit;

    /**
     * Mandatory
     * The values to be imported on DHIS2 forms
     */
    private List<DataElementValue> dataValues;

    public String getDataSet() {
        return dataSet;
    }

    public void setDataSet(String dataSet) {
        this.dataSet = dataSet;
    }

    public Date getCompleteData() {
        return completeData;
    }

    public void setCompleteData(Date completeData) {
        this.completeData = completeData;
    }

    public String getPeriod() {
        return period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public String getOrgUnit() {
        return orgUnit;
    }

    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public List<DataElementValue> getDataValues() {
        return dataValues;
    }

    public void setDataValues(List<DataElementValue> dataValues) {
        this.dataValues = dataValues;
    }

    /**
     * Searches the DataElementValue based on dataelementId and categoryOptionComboId.
     * If find any match, sums the current value of DataElementValue with the value on param.
     * If the DataElementValue is not found, a new DataElementValue is created and stored on dataValues List
     * @param dataElementId
     * @param categoryOptionComboId
     * @param value
     */
    public void mergeDataValue(String dataElementId, String categoryOptionComboId, Long value) {
        if (dataElementId == null) {
            throw new RuntimeException("Data Element Id must be informed.");
        }

        // if data value list is empty doesn't exists
        if (dataValues == null || dataValues.isEmpty()) {
            dataValues = new ArrayList<DataElementValue>();
            dataValues.add(new DataElementValue(dataElementId, categoryOptionComboId, value));
            return;
        }

        // look for the data value checking the data element id and category option combo id
        // if find it, merge the values.
        // category option combo is optional.
        for (DataElementValue data : dataValues) {
            if (data.getDataElement().equals(dataElementId) &&
                    ((categoryOptionComboId == null && data.getCategoryOptionCombo() == null) ||
                        data.getCategoryOptionCombo().equals(categoryOptionComboId))) {
                data.mergeValue(value);
                return;
            }
        }

        // the data element value doesn't exists, so create it.
        dataValues.add(new DataElementValue(dataElementId, categoryOptionComboId, value));
    }
}
